#undef NUNIT
using System;
using System.Data;
using System.Collections;
using System.Reflection;
using Method = System.Reflection.MethodBase;

namespace gov.va.med.vbecs.BOL
{
    
		#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Margaret Jablonski</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>7/28/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		//<summary></summary>

		#endregion

	/// <summary>
	/// ABO/Rh Business Object
	/// </summary>
	public class AboRh : gov.va.med.vbecs.BOL.BaseBusinessObject
	{

		#region Variables

		private Common.ABO _abo = Common.ABO.NA;
		private Common.RH _rh = Common.RH.NotProvided;
        private const string POOLED_TXT = "Pooled";
		#endregion

		#region Constructors


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3302"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Valid AboRh object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="195"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ABO/Rh Blank Constructor
		/// </summary>
		public AboRh()
		{
			this._abo = Common.ABO.NA;
			this._rh = Common.RH.NotProvided;
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="311"> 
		///		<ExpectedInput>Abo and Rh Values</ExpectedInput>
		///		<ExpectedOutput>AboRh object with input values</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="313"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AboRh Constructor with ABO and RH parameters
		/// </summary>
		/// <param name="abo"></param>
		/// <param name="rh"></param>
		public AboRh(Common.ABO abo, Common.RH rh)
		{
			this._abo = abo;
			this._rh = rh;
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1872"> 
		///		<ExpectedInput>Common.ABO value</ExpectedInput>
		///		<ExpectedOutput>Input value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="196"> 
		///		<ExpectedInput>Common.ABO.NA</ExpectedInput>
		///		<ExpectedOutput>BrokenRule</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets patient's blood type code
		/// </summary>
		public Common.ABO Abo
		{
			get
			{
				return this._abo;
			}
			set
			{
				RuleBroken(Method.GetCurrentMethod().Name, (value == Common.ABO.NA));

				this._abo = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="587"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>blood type and _rh factor properties</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="197"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets blood type and Rh factor.  Same as AboRhTextExpanded, only abbreviated.
		/// According to TT_1.09, Pooled ABO should appear as 'Pooled ABO'.  
		/// Same for RH, only with RH.  MOst of our screens don't have the 
		/// real estate for this, so this Version will show 'Pooled'.
		/// </summary>
		public string AboRHText
		{
			get
			{
				if (this._abo == Common.ABO.NA)
				{
					return "NR";
				}
				else
				{
					if (this._rh != Common.RH.NotProvided)
					{
						if (this._abo == Common.ABO.Mx)
							return(POOLED_TXT + " " + this.RHFactorText);
						else
							return(this._abo.ToString().Trim() + " " + this.RHFactorText);
					}
					else
					{
						if (this._abo == Common.ABO.Mx)
							return(POOLED_TXT);
						else
							return(this._abo.ToString().Trim());
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5051"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Long version of blood type and _rh factor properties</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5052"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This is the same as AboRhText, only longer (more chars) (FOR TOOLTIPS).
		/// According to TT_1.09, Pooled ABO should appear as 'Pooled ABO'.  
		/// Same for RH, only with RH.  MOst of our screens don't have the 
		/// real estate for this, so this long Version will go in the tooltip for all screens
		/// that have ABO/RH display so the user gets the expanded text (since Pl ABO is SOooooooo hard to interpret as Pooled ABO)
		/// </summary>
		public string AboRHTextExpanded
		{
			get
			{
				if (this._abo == Common.ABO.NA)
				{
					return "NR";
				}
				else
				{
					if (this._rh != Common.RH.NotProvided)
					{
						if (this._abo == Common.ABO.Mx)
							return(POOLED_TXT + " ABO" + " " + this.RHFactorText);
						else
							return(this._abo.ToString().Trim() + " " + this.RHFactorText);
					}
					else
					{
						if (this._abo == Common.ABO.Mx)
							return(POOLED_TXT + " ABO");
						else
							return(this._abo.ToString().Trim());
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1874"> 
		///		<ExpectedInput>Common.RH value</ExpectedInput>
		///		<ExpectedOutput>Input value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="198"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets patient's Rh factor
		/// </summary>
		public Common.RH RH
		{
			get
			{
				return this._rh;
			}
			set
			{
				this._rh = value;
			}
		}
		

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3298"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>RhFactor text for current objects' code value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="199"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns Rh code from Rh text
		/// </summary>
		public string RHFactorCode 
		{
			get
			{
				string RhCode = string.Empty;

				switch (this._rh)
				{
					case Common.RH.Inconclusive:
					{
						RhCode = "I";
						break;
					}
					case Common.RH.Negative:
					{
						RhCode = "N";
						break;
					}
					case Common.RH.NotProvided:
					{
						RhCode = "U";
						break;
					}
					case Common.RH.PooledRH:
					{
						RhCode = "Y";
						break;
					}
					case Common.RH.Positive:
					{
						RhCode = "P";
						break;
					}
					default:	//Common.RH.Blank:
					{
						RhCode = "Z";
						break;
					}

				}

				return RhCode;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3300"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>String abbreviation of our RH enum value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="268"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns RhFactorText
		/// </summary>
		public string RHFactorText
		{
			get
			{
				string RhText = string.Empty;

				switch(this._rh)
				{
					case Common.RH.Inconclusive:
					{
						RhText = "Inc";
						break;
					}
					case Common.RH.Negative:
					{
						RhText = "Neg";
						break;
					}
					case Common.RH.NotProvided:
					{
						RhText = "Unk";
						break;
					}
					case Common.RH.PooledRH:
					{
						RhText = "Pooled";
						break;
					}
					case Common.RH.Positive:
					{
						RhText = "Pos";
						break;
					}
					default:		//Common.RH.Blank:
					{
						RhText = string.Empty;
						break;
					}
				}

				return RhText;
			}
		}

		#endregion

		#region Methods


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///
		///<Case type="0" testid ="3295"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow with object values</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="270"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(Common.VbecsTables.RhFactor.RhFactorCode))
			{
				dtRow[Common.VbecsTables.RhFactor.RhFactorCode] = this.RHFactorCode;
			}

			if (dtRow.Table.Columns.Contains(Common.VbecsTables.RhFactor.RhFactorText))
			{
				dtRow[Common.VbecsTables.RhFactor.RhFactorText] = this.RHFactorText;
			}

			if (dtRow.Table.Columns.Contains(Common.VbecsTables.BloodUnitMedia.BloodTypeCode))
			{
				dtRow[Common.VbecsTables.BloodUnitMedia.BloodTypeCode] = this.Abo.ToString();
			}

			return dtRow;
		}


		/// <summary>
		/// Loads properties from DataRow
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			//Not needed
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/19/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2220"> 
		///		<ExpectedInput>Valid Rh code</ExpectedInput>
		///		<ExpectedOutput>Valid Common.RH value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2221"> 
		///		<ExpectedInput>Invalid Rh code</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Private function to return Rh enum from Rh code
		/// </summary>
		/// <param name="rhCode">Rh Factor code</param>
		/// <returns>Rh Factor enum</returns>
		public static Common.RH GetRHFromCode(string rhCode)
		{
			Common.RH RhEnum;
			//
			switch(rhCode.Trim().ToUpper())
			{
				case "P":
				{
					RhEnum = Common.RH.Positive;
					break;
				}
				case "N":
				{
					RhEnum = Common.RH.Negative;
					break;
				}
				case "I":
				{
					RhEnum = Common.RH.Inconclusive;
					break;
				}
				case "U":
				{
					RhEnum = Common.RH.NotProvided;
					break;
				}
				case "Y":
				{
					RhEnum = Common.RH.PooledRH;
					break;
				}
				case "Z":
				{
					RhEnum = Common.RH.Blank;
					break;
				}
				case "":
				{
					RhEnum = Common.RH.NotProvided;
					break;
				}
				default:
				{
					throw new BOL.BusinessObjectException("Invalid RH");
				}
			}
			return RhEnum;
			
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3463"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>The data table containing AboRh data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="202"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves a list of all possible blood type and Rh factors.
		/// Blood type and Rh are concatenated together.
		/// </summary>
		/// <returns>DataTable containing all possible blood type and Rh factors</returns>
		public static DataTable GetAllAboRH()
		{
			return DAL.AboRh.GetAllAboRH();
		}     

		//
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2218"> 
		///		<ExpectedInput>Valid ABO string</ExpectedInput>
		///		<ExpectedOutput>Valid ABO type</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2219"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representing ABO from a string.
		/// </summary>
		/// <param name="abo"></param>
		/// <returns></returns>
		public static Common.ABO GetAboFromString(string abo)
		{
			Common.ABO ABO = Common.ABO.NA;

			switch(abo.Trim().ToUpper())
			{
				case("A"):
				{
					ABO = Common.ABO.A;
					break;
				}
				case("AB"):
				{
					ABO = Common.ABO.AB;
					break;
				}
				case("O"):
				{
					ABO = Common.ABO.O;
					break;
				}
				case("B"):
				{
					ABO = Common.ABO.B;
					break;
				}
				case("POOLED"):
				{
					ABO = Common.ABO.Mx;
					break;
				}
				case("MX"):
				{
					ABO = Common.ABO.Mx;
					break;
				}
				case("I"):
				{
					ABO = Common.ABO.I;
					break;
				}
			}
            
			return ABO;
		}


		#endregion

	}
}

